#include "skse64/NiRTTI.h"
#include "skse64/NiObjects.h"

NiObject * DoNiRTTICast(NiObject * src, const NiRTTI * typeInfo)
{
	uintptr_t typeAddr = uintptr_t(typeInfo) + RelocationManager::s_baseAddr;
	if (src)
		for (NiRTTI * iter = src->GetRTTI(); iter; iter = iter->parent)
			if (iter == (NiRTTI *)typeAddr)
				return src;

	return nullptr;
}

bool IsType(NiRTTI * rtti, const NiRTTI * typeInfo)
{
	uintptr_t typeAddr = uintptr_t(typeInfo) + RelocationManager::s_baseAddr;
	if (rtti)
		return uintptr_t(rtti) == typeAddr;

	return false;
}

const NiRTTI *	NiRTTI_BGSDecalNode = (NiRTTI *)0x020FC190;
const NiRTTI *	NiRTTI_BSAnimGroupSequence = (NiRTTI *)0x020FC2F0;
const NiRTTI *	NiRTTI_BSSplatterExtraData = (NiRTTI *)0x030FD340;
const NiRTTI *	NiRTTI_BGSAddonNodeSoundHandleExtra = (NiRTTI *)0x030FD7A8;
const NiRTTI *	NiRTTI_REFRSyncController = (NiRTTI *)0x031377B0;
const NiRTTI *	NiRTTI_bhkCartTether = (NiRTTI *)0x03138E18;
const NiRTTI *	NiRTTI_bhkTiltPreventAction = (NiRTTI *)0x03138E28;
const NiRTTI *	NiRTTI_bhkWheelAction = (NiRTTI *)0x03138E38;
const NiRTTI *	NiRTTI_BSFaceGenAnimationData = (NiRTTI *)0x03139478;
const NiRTTI *	NiRTTI_BSFaceGenModelExtraData = (NiRTTI *)0x0313F9A0;
const NiRTTI *	NiRTTI_BSFaceGenBaseMorphExtraData = (NiRTTI *)0x0313F9C8;
const NiRTTI *	NiRTTI_BSFaceGenMorphData = (NiRTTI *)0x0313F9D8;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHead = (NiRTTI *)0x0313F9E8;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHair = (NiRTTI *)0x0313F9F8;
const NiRTTI *	NiRTTI_BSFaceGenNiNode = (NiRTTI *)0x0313FA38;
const NiRTTI *	NiRTTI_BSTempEffect = (NiRTTI *)0x03144E08;
const NiRTTI *	NiRTTI_BSTempEffectDebris = (NiRTTI *)0x03144E88;
const NiRTTI *	NiRTTI_BSTempEffectGeometryDecal = (NiRTTI *)0x03144EA8;
const NiRTTI *	NiRTTI_BSTempEffectParticle = (NiRTTI *)0x03144F58;
const NiRTTI *	NiRTTI_BSTempEffectSimpleDecal = (NiRTTI *)0x03144F80;
const NiRTTI *	NiRTTI_BSTempEffectSPG = (NiRTTI *)0x03144F98;
const NiRTTI *	NiRTTI_bhkAutoWater = (NiRTTI *)0x0315C380;
const NiRTTI *	NiRTTI_ModelReferenceEffect = (NiRTTI *)0x03169C58;
const NiRTTI *	NiRTTI_ReferenceEffect = (NiRTTI *)0x03169C90;
const NiRTTI *	NiRTTI_ShaderReferenceEffect = (NiRTTI *)0x03169CC0;
const NiRTTI *	NiRTTI_SummonPlacementEffect = (NiRTTI *)0x03169CF0;
const NiRTTI *	NiRTTI_SceneGraph = (NiRTTI *)0x03199378;
const NiRTTI *	NiRTTI_BSDoorHavokController = (NiRTTI *)0x0319B098;
const NiRTTI *	NiRTTI_BSPlayerDistanceCheckController = (NiRTTI *)0x0319B0A8;
const NiRTTI *	NiRTTI_BSSimpleScaleController = (NiRTTI *)0x0319B0B8;
const NiRTTI *	NiRTTI_NiObject = (NiRTTI *)0x03272CB0;
const NiRTTI *	NiRTTI_NiAVObject = (NiRTTI *)0x03272CE8;
const NiRTTI *	NiRTTI_NiNode = (NiRTTI *)0x03272D08;
const NiRTTI *	NiRTTI_NiObjectNET = (NiRTTI *)0x03272E88;
const NiRTTI *	NiRTTI_NiLight = (NiRTTI *)0x03272EE0;
const NiRTTI *	NiRTTI_NiSwitchNode = (NiRTTI *)0x03272EF0;
const NiRTTI *	NiRTTI_NiStringsExtraData = (NiRTTI *)0x03272F00;
const NiRTTI *	NiRTTI_NiCamera = (NiRTTI *)0x03272F10;
const NiRTTI *	NiRTTI_BSTriShape = (NiRTTI *)0x03272F28;
const NiRTTI *	NiRTTI_NiProperty = (NiRTTI *)0x03272F38;
const NiRTTI *	NiRTTI_NiAlphaProperty = (NiRTTI *)0x03272F50;
const NiRTTI *	NiRTTI_NiSourceTexture = (NiRTTI *)0x03273F88;
const NiRTTI *	NiRTTI_BSFlattenedBoneTree = (NiRTTI *)0x03273F98;
const NiRTTI *	NiRTTI_BSDismemberSkinInstance = (NiRTTI *)0x03273FE0;
const NiRTTI *	NiRTTI_NiStringExtraData = (NiRTTI *)0x03273FF0;
const NiRTTI *	NiRTTI_NiTimeController = (NiRTTI *)0x03274000;
const NiRTTI *	NiRTTI_NiExtraData = (NiRTTI *)0x03274020;
const NiRTTI *	NiRTTI_NiGeometryData = (NiRTTI *)0x03274030;
const NiRTTI *	NiRTTI_BSGeometry = (NiRTTI *)0x03274048;
const NiRTTI *	NiRTTI_BSDynamicTriShape = (NiRTTI *)0x03274060;
const NiRTTI *	NiRTTI_NiPointLight = (NiRTTI *)0x03274070;
const NiRTTI *	NiRTTI_NiDefaultAVObjectPalette = (NiRTTI *)0x03274080;
const NiRTTI *	NiRTTI_NiBillboardNode = (NiRTTI *)0x032740A8;
const NiRTTI *	NiRTTI_NiDirectionalLight = (NiRTTI *)0x032740B8;
const NiRTTI *	NiRTTI_NiCullingProcess = (NiRTTI *)0x032740C8;
const NiRTTI *	NiRTTI_NiParticles = (NiRTTI *)0x032740E0;
const NiRTTI *	NiRTTI_NiTexture = (NiRTTI *)0x03274120;
const NiRTTI *	NiRTTI_NiSkinPartition = (NiRTTI *)0x03274230;
const NiRTTI *	NiRTTI_NiVertWeightsExtraData = (NiRTTI *)0x03274240;
const NiRTTI *	NiRTTI_NiSkinInstance = (NiRTTI *)0x03274250;
const NiRTTI *	NiRTTI_NiAVObjectPalette = (NiRTTI *)0x03274260;
const NiRTTI *	NiRTTI_NiGeometry = (NiRTTI *)0x03274270;
const NiRTTI *	NiRTTI_NiSkinData = (NiRTTI *)0x032742A0;
const NiRTTI *	NiRTTI_NiShadeProperty = (NiRTTI *)0x032742B0;
const NiRTTI *	NiRTTI_NiAlphaAccumulator = (NiRTTI *)0x032742C8;
const NiRTTI *	NiRTTI_NiAmbientLight = (NiRTTI *)0x032742D8;
const NiRTTI *	NiRTTI_NiBinaryExtraData = (NiRTTI *)0x032742E8;
const NiRTTI *	NiRTTI_NiBooleanExtraData = (NiRTTI *)0x032742F8;
const NiRTTI *	NiRTTI_NiBSPNode = (NiRTTI *)0x03274308;
const NiRTTI *	NiRTTI_NiColorExtraData = (NiRTTI *)0x03274318;
const NiRTTI *	NiRTTI_NiFloatExtraData = (NiRTTI *)0x03274328;
const NiRTTI *	NiRTTI_NiFloatsExtraData = (NiRTTI *)0x03274338;
const NiRTTI *	NiRTTI_NiFogProperty = (NiRTTI *)0x03274348;
const NiRTTI *	NiRTTI_NiIntegerExtraData = (NiRTTI *)0x03274360;
const NiRTTI *	NiRTTI_NiIntegersExtraData = (NiRTTI *)0x03274370;
const NiRTTI *	NiRTTI_NiParticlesData = (NiRTTI *)0x032743B8;
const NiRTTI *	NiRTTI_NiParticleMeshesData = (NiRTTI *)0x032743C8;
const NiRTTI *	NiRTTI_NiParticleMeshes = (NiRTTI *)0x032743D8;
const NiRTTI *	NiRTTI_NiSpotLight = (NiRTTI *)0x032743E8;
const NiRTTI *	NiRTTI_NiSwitchStringExtraData = (NiRTTI *)0x032743F8;
const NiRTTI *	NiRTTI_NiTriShapeData = (NiRTTI *)0x03274408;
const NiRTTI *	NiRTTI_NiTriShape = (NiRTTI *)0x03274418;
const NiRTTI *	NiRTTI_NiTriStripsData = (NiRTTI *)0x03274428;
const NiRTTI *	NiRTTI_NiTriStrips = (NiRTTI *)0x03274438;
const NiRTTI *	NiRTTI_NiVectorExtraData = (NiRTTI *)0x03274448;
const NiRTTI *	NiRTTI_BSLODTriShape = (NiRTTI *)0x03274470;
const NiRTTI *	NiRTTI_NiAdditionalGeometryData = (NiRTTI *)0x03274480;
const NiRTTI *	NiRTTI_BSSegmentedTriShape = (NiRTTI *)0x03274498;
const NiRTTI *	NiRTTI_NiBackToFrontAccumulator = (NiRTTI *)0x032744D0;
const NiRTTI *	NiRTTI_NiAccumulator = (NiRTTI *)0x032744E0;
const NiRTTI *	NiRTTI_NiTriBasedGeomData = (NiRTTI *)0x032744F0;
const NiRTTI *	NiRTTI_NiTriBasedGeom = (NiRTTI *)0x03274500;
const NiRTTI *	NiRTTI_NiCollisionData = (NiRTTI *)0x03274540;
const NiRTTI *	NiRTTI_NiControllerManager = (NiRTTI *)0x032745D8;
const NiRTTI *	NiRTTI_NiControllerSequence = (NiRTTI *)0x032745F8;
const NiRTTI *	NiRTTI_NiBlendInterpolator = (NiRTTI *)0x03274628;
const NiRTTI *	NiRTTI_NiMultiTargetTransformController = (NiRTTI *)0x03274638;
const NiRTTI *	NiRTTI_BSMultiTargetTreadTransfController = (NiRTTI *)0x03274648;
const NiRTTI *	NiRTTI_NiInterpController = (NiRTTI *)0x03274658;
const NiRTTI *	NiRTTI_NiFloatData = (NiRTTI *)0x03275428;
const NiRTTI *	NiRTTI_NiFloatInterpolator = (NiRTTI *)0x03275438;
const NiRTTI *	NiRTTI_NiColorData = (NiRTTI *)0x03275448;
const NiRTTI *	NiRTTI_NiColorInterpolator = (NiRTTI *)0x03275458;
const NiRTTI *	NiRTTI_NiSingleInterpController = (NiRTTI *)0x03275468;
const NiRTTI *	NiRTTI_NiTransformInterpolator = (NiRTTI *)0x03275478;
const NiRTTI *	NiRTTI_NiPathInterpolator = (NiRTTI *)0x03275488;
const NiRTTI *	NiRTTI_NiBlendTransformInterpolator = (NiRTTI *)0x032754A8;
const NiRTTI *	NiRTTI_NiBlendFloatInterpolator = (NiRTTI *)0x032754B8;
const NiRTTI *	NiRTTI_NiFloatExtraDataController = (NiRTTI *)0x032754C8;
const NiRTTI *	NiRTTI_NiTransformController = (NiRTTI *)0x032754D8;
const NiRTTI *	NiRTTI_NiBlendAccumTransformInterpolator = (NiRTTI *)0x032754E8;
const NiRTTI *	NiRTTI_NiInterpolator = (NiRTTI *)0x03275500;
const NiRTTI *	NiRTTI_BSBlendTreadTransfInterpolator = (NiRTTI *)0x03275520;
const NiRTTI *	NiRTTI_NiKeyBasedInterpolator = (NiRTTI *)0x03275538;
const NiRTTI *	NiRTTI_NiTransformData = (NiRTTI *)0x032755B8;
const NiRTTI *	NiRTTI_NiPosData = (NiRTTI *)0x032755C8;
const NiRTTI *	NiRTTI_NiBlendBoolInterpolator = (NiRTTI *)0x032755D8;
const NiRTTI *	NiRTTI_NiBlendColorInterpolator = (NiRTTI *)0x032755E8;
const NiRTTI *	NiRTTI_NiBlendPoint3Interpolator = (NiRTTI *)0x032755F8;
const NiRTTI *	NiRTTI_NiBlendQuaternionInterpolator = (NiRTTI *)0x03275608;
const NiRTTI *	NiRTTI_NiBoolData = (NiRTTI *)0x03275618;
const NiRTTI *	NiRTTI_NiBoolInterpolator = (NiRTTI *)0x03275628;
const NiRTTI *	NiRTTI_NiBoolTimelineInterpolator = (NiRTTI *)0x03275638;
const NiRTTI *	NiRTTI_NiBSplineBasisData = (NiRTTI *)0x03275648;
const NiRTTI *	NiRTTI_NiBSplineData = (NiRTTI *)0x03275658;
const NiRTTI *	NiRTTI_NiBSplineColorInterpolator = (NiRTTI *)0x03275668;
const NiRTTI *	NiRTTI_NiBSplineCompColorInterpolator = (NiRTTI *)0x03275678;
const NiRTTI *	NiRTTI_NiBSplineCompFloatInterpolator = (NiRTTI *)0x03275688;
const NiRTTI *	NiRTTI_NiBSplineCompPoint3Interpolator = (NiRTTI *)0x03275698;
const NiRTTI *	NiRTTI_NiBSplineCompTransformInterpolator = (NiRTTI *)0x032756A8;
const NiRTTI *	NiRTTI_NiBSplineFloatInterpolator = (NiRTTI *)0x032756B8;
const NiRTTI *	NiRTTI_NiBSplinePoint3Interpolator = (NiRTTI *)0x032756C8;
const NiRTTI *	NiRTTI_NiBSplineTransformInterpolator = (NiRTTI *)0x032756D8;
const NiRTTI *	NiRTTI_NiColorExtraDataController = (NiRTTI *)0x032756E8;
const NiRTTI *	NiRTTI_NiFloatsExtraDataController = (NiRTTI *)0x032756F8;
const NiRTTI *	NiRTTI_NiFloatsExtraDataPoint3Controller = (NiRTTI *)0x03275708;
const NiRTTI *	NiRTTI_NiKeyframeManager = (NiRTTI *)0x03275720;
const NiRTTI *	NiRTTI_NiLightColorController = (NiRTTI *)0x03275730;
const NiRTTI *	NiRTTI_NiLightDimmerController = (NiRTTI *)0x03275740;
const NiRTTI *	NiRTTI_NiLookAtController = (NiRTTI *)0x03275750;
const NiRTTI *	NiRTTI_NiLookAtInterpolator = (NiRTTI *)0x03275760;
const NiRTTI *	NiRTTI_NiMorphData = (NiRTTI *)0x03275770;
const NiRTTI *	NiRTTI_NiPathController = (NiRTTI *)0x03275780;
const NiRTTI *	NiRTTI_NiPoint3Interpolator = (NiRTTI *)0x03275790;
const NiRTTI *	NiRTTI_NiQuaternionInterpolator = (NiRTTI *)0x032757A0;
const NiRTTI *	NiRTTI_NiRollController = (NiRTTI *)0x032757B0;
const NiRTTI *	NiRTTI_NiRotData = (NiRTTI *)0x032757C0;
const NiRTTI *	NiRTTI_NiSequence = (NiRTTI *)0x032757D0;
const NiRTTI *	NiRTTI_NiSequenceStreamHelper = (NiRTTI *)0x032757F0;
const NiRTTI *	NiRTTI_NiStringPalette = (NiRTTI *)0x03275800;
const NiRTTI *	NiRTTI_NiTextKeyExtraData = (NiRTTI *)0x03275810;
const NiRTTI *	NiRTTI_NiUVData = (NiRTTI *)0x03275820;
const NiRTTI *	NiRTTI_NiVisController = (NiRTTI *)0x03275830;
const NiRTTI *	NiRTTI_BSAnimNote = (NiRTTI *)0x03275840;
const NiRTTI *	NiRTTI_BSAnimNotes = (NiRTTI *)0x03275850;
const NiRTTI *	NiRTTI_BSGrabIKNote = (NiRTTI *)0x03275860;
const NiRTTI *	NiRTTI_BSLookIKNote = (NiRTTI *)0x03275870;
const NiRTTI *	NiRTTI_BSRotAccumTransfInterpolator = (NiRTTI *)0x03275880;
const NiRTTI *	NiRTTI_BSTreadTransfInterpolator = (NiRTTI *)0x03275890;
const NiRTTI *	NiRTTI_BSFrustumFOVController = (NiRTTI *)0x032758A0;
const NiRTTI *	NiRTTI_NiExtraDataController = (NiRTTI *)0x03275938;
const NiRTTI *	NiRTTI_NiBSplineInterpolator = (NiRTTI *)0x03275948;
const NiRTTI *	NiRTTI_NiPoint3InterpController = (NiRTTI *)0x03275958;
const NiRTTI *	NiRTTI_NiFloatInterpController = (NiRTTI *)0x03275968;
const NiRTTI *	NiRTTI_NiFloatController = (NiRTTI *)0x03275978;
const NiRTTI *	NiRTTI_NiBoolInterpController = (NiRTTI *)0x03275988;
const NiRTTI *	NiRTTI_NiParticleSystem = (NiRTTI *)0x032759A0;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlr = (NiRTTI *)0x032759B0;
const NiRTTI *	NiRTTI_NiPSysGravityModifier = (NiRTTI *)0x032759C0;
const NiRTTI *	NiRTTI_BSPSysHavokUpdateModifier = (NiRTTI *)0x032759D0;
const NiRTTI *	NiRTTI_NiMeshParticleSystem = (NiRTTI *)0x032759E8;
const NiRTTI *	NiRTTI_NiPSysCylinderEmitter = (NiRTTI *)0x03275A00;
const NiRTTI *	NiRTTI_BSStripParticleSystem = (NiRTTI *)0x03275A10;
const NiRTTI *	NiRTTI_NiPSysEmitter = (NiRTTI *)0x03275A20;
const NiRTTI *	NiRTTI_NiPSysModifierCtlr = (NiRTTI *)0x03275A30;
const NiRTTI *	NiRTTI_NiPSysModifier = (NiRTTI *)0x03275A48;
const NiRTTI *	NiRTTI_NiPSysMeshUpdateModifier = (NiRTTI *)0x03275A58;
const NiRTTI *	NiRTTI_NiPSysUpdateCtlr = (NiRTTI *)0x03275A68;
const NiRTTI *	NiRTTI_NiMeshPSysData = (NiRTTI *)0x03275A78;
const NiRTTI *	NiRTTI_NiPSysAirFieldAirFrictionCtlr = (NiRTTI *)0x03275A88;
const NiRTTI *	NiRTTI_NiPSysAirFieldInheritVelocityCtlr = (NiRTTI *)0x03275A98;
const NiRTTI *	NiRTTI_NiPSysAirFieldModifier = (NiRTTI *)0x03275AA8;
const NiRTTI *	NiRTTI_NiPSysAirFieldSpreadCtlr = (NiRTTI *)0x03275AB8;
const NiRTTI *	NiRTTI_NiPSysAgeDeathModifier = (NiRTTI *)0x03275AC8;
const NiRTTI *	NiRTTI_NiPSysBombModifier = (NiRTTI *)0x03275AD8;
const NiRTTI *	NiRTTI_NiPSysBoundUpdateModifier = (NiRTTI *)0x03275AE8;
const NiRTTI *	NiRTTI_NiPSysBoxEmitter = (NiRTTI *)0x03275AF8;
const NiRTTI *	NiRTTI_NiPSysColliderManager = (NiRTTI *)0x03275B08;
const NiRTTI *	NiRTTI_NiPSysColorModifier = (NiRTTI *)0x03275B18;
const NiRTTI *	NiRTTI_NiPSysData = (NiRTTI *)0x03275B28;
const NiRTTI *	NiRTTI_NiPSysDragFieldModifier = (NiRTTI *)0x03275B38;
const NiRTTI *	NiRTTI_NiPSysDragModifier = (NiRTTI *)0x03275B48;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlrData = (NiRTTI *)0x03275B58;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationCtlr = (NiRTTI *)0x03275B68;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationVarCtlr = (NiRTTI *)0x03275B78;
const NiRTTI *	NiRTTI_NiPSysEmitterInitialRadiusCtlr = (NiRTTI *)0x03275B88;
const NiRTTI *	NiRTTI_NiPSysEmitterLifeSpanCtlr = (NiRTTI *)0x03275B98;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleCtlr = (NiRTTI *)0x03275BA8;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleVarCtlr = (NiRTTI *)0x03275BB8;
const NiRTTI *	NiRTTI_NiPSysEmitterSpeedCtlr = (NiRTTI *)0x03275BC8;
const NiRTTI *	NiRTTI_NiPSysFieldAttenuationCtlr = (NiRTTI *)0x03275BD8;
const NiRTTI *	NiRTTI_NiPSysFieldMagnitudeCtlr = (NiRTTI *)0x03275BE8;
const NiRTTI *	NiRTTI_NiPSysFieldMaxDistanceCtlr = (NiRTTI *)0x03275BF8;
const NiRTTI *	NiRTTI_NiPSysGravityFieldModifier = (NiRTTI *)0x03275C08;
const NiRTTI *	NiRTTI_NiPSysGravityStrengthCtlr = (NiRTTI *)0x03275C18;
const NiRTTI *	NiRTTI_NiPSysGrowFadeModifier = (NiRTTI *)0x03275C28;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleCtlr = (NiRTTI *)0x03275C38;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleVarCtlr = (NiRTTI *)0x03275C48;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedCtlr = (NiRTTI *)0x03275C58;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedVarCtlr = (NiRTTI *)0x03275C68;
const NiRTTI *	NiRTTI_NiPSysMeshEmitter = (NiRTTI *)0x03275C78;
const NiRTTI *	NiRTTI_NiPSysModifierActiveCtlr = (NiRTTI *)0x03275CA8;
const NiRTTI *	NiRTTI_NiPSysPlanarCollider = (NiRTTI *)0x03275CB8;
const NiRTTI *	NiRTTI_NiPSysPositionModifier = (NiRTTI *)0x03275CC8;
const NiRTTI *	NiRTTI_NiPSysRadialFieldModifier = (NiRTTI *)0x03275CD8;
const NiRTTI *	NiRTTI_NiPSysResetOnLoopCtlr = (NiRTTI *)0x03275CE8;
const NiRTTI *	NiRTTI_NiPSysRotationModifier = (NiRTTI *)0x03275CF8;
const NiRTTI *	NiRTTI_NiPSysSpawnModifier = (NiRTTI *)0x03275D08;
const NiRTTI *	NiRTTI_NiPSysSphereEmitter = (NiRTTI *)0x03275D18;
const NiRTTI *	NiRTTI_NiPSysSphericalCollider = (NiRTTI *)0x03275D28;
const NiRTTI *	NiRTTI_NiPSysTurbulenceFieldModifier = (NiRTTI *)0x03275D38;
const NiRTTI *	NiRTTI_NiPSysVortexFieldModifier = (NiRTTI *)0x03275D48;
const NiRTTI *	NiRTTI_BSStripPSysData = (NiRTTI *)0x03275D58;
const NiRTTI *	NiRTTI_BSPSysRecycleBoundModifier = (NiRTTI *)0x03275D70;
const NiRTTI *	NiRTTI_BSPSysInheritVelocityModifier = (NiRTTI *)0x03275D80;
const NiRTTI *	NiRTTI_NiPSysVolumeEmitter = (NiRTTI *)0x03275D90;
const NiRTTI *	NiRTTI_NiPSysModifierFloatCtlr = (NiRTTI *)0x03275DA0;
const NiRTTI *	NiRTTI_NiPSysFieldModifier = (NiRTTI *)0x03275DB0;
const NiRTTI *	NiRTTI_NiPSysModifierBoolCtlr = (NiRTTI *)0x03275DC0;
const NiRTTI *	NiRTTI_NiPSysCollider = (NiRTTI *)0x03275DD0;
const NiRTTI *	NiRTTI_BSMultiBound = (NiRTTI *)0x0327E088;
const NiRTTI *	NiRTTI_BSMultiBoundRoom = (NiRTTI *)0x0327E098;
const NiRTTI *	NiRTTI_BSMultiBoundAABB = (NiRTTI *)0x0327E0B0;
const NiRTTI *	NiRTTI_BSMultiBoundOBB = (NiRTTI *)0x0327E0C8;
const NiRTTI *	NiRTTI_BSXFlags = (NiRTTI *)0x0327E0E8;
const NiRTTI *	NiRTTI_BSValueNode = (NiRTTI *)0x0327E100;
const NiRTTI *	NiRTTI_BSWindModifier = (NiRTTI *)0x03284680;
const NiRTTI *	NiRTTI_BSTempNodeManager = (NiRTTI *)0x032846A0;
const NiRTTI *	NiRTTI_BSTempNode = (NiRTTI *)0x032846B0;
const NiRTTI *	NiRTTI_BSOcclusionShape = (NiRTTI *)0x032846D0;
const NiRTTI *	NiRTTI_BSRangeNode = (NiRTTI *)0x032847C8;
const NiRTTI *	NiRTTI_BSBlastNode = (NiRTTI *)0x03284A00;
const NiRTTI *	NiRTTI_BSDebrisNode = (NiRTTI *)0x03284A10;
const NiRTTI *	NiRTTI_BSDamageStage = (NiRTTI *)0x03284A20;
const NiRTTI *	NiRTTI_BSPSysArrayEmitter = (NiRTTI *)0x03284A30;
const NiRTTI *	NiRTTI_PArrayPoint = (NiRTTI *)0x03284A40;
const NiRTTI *	NiRTTI_BSMultiStreamInstanceTriShape = (NiRTTI *)0x03284A68;
const NiRTTI *	NiRTTI_BSMultiBoundShape = (NiRTTI *)0x03284A98;
const NiRTTI *	NiRTTI_BSMultiBoundSphere = (NiRTTI *)0x03284AA8;
const NiRTTI *	NiRTTI_BSOcclusionBox = (NiRTTI *)0x03284AC0;
const NiRTTI *	NiRTTI_BSOcclusionPlane = (NiRTTI *)0x03284AD8;
const NiRTTI *	NiRTTI_BSPortal = (NiRTTI *)0x03284AE8;
const NiRTTI *	NiRTTI_BSPortalSharedNode = (NiRTTI *)0x03284AF8;
const NiRTTI *	NiRTTI_BSBodyMorphOffsetsExtraData = (NiRTTI *)0x03284B10;
const NiRTTI *	NiRTTI_BSBehaviorGraphExtraData = (NiRTTI *)0x03284B20;
const NiRTTI *	NiRTTI_NiBSBoneLODController = (NiRTTI *)0x03284B38;
const NiRTTI *	NiRTTI_BSCullingProcess = (NiRTTI *)0x03284B58;
const NiRTTI *	NiRTTI_BSParticleSystemManager = (NiRTTI *)0x03284B78;
const NiRTTI *	NiRTTI_BSFurnitureMarkerNode = (NiRTTI *)0x03284BA0;
const NiRTTI *	NiRTTI_BSBound = (NiRTTI *)0x03284C20;
const NiRTTI *	NiRTTI_BSMultiBoundNode = (NiRTTI *)0x03284C40;
const NiRTTI *	NiRTTI_BSBoneMap = (NiRTTI *)0x03284C50;
const NiRTTI *	NiRTTI_BSAnimInteractionMarker = (NiRTTI *)0x03284C68;
const NiRTTI *	NiRTTI_BSSceneGraph = (NiRTTI *)0x03284C80;
const NiRTTI *	NiRTTI_BSPSysMultiTargetEmitterCtlr = (NiRTTI *)0x03284C98;
const NiRTTI *	NiRTTI_BSGeometryListCullingProcess = (NiRTTI *)0x03284CB0;
const NiRTTI *	NiRTTI_BSSubIndexTriShape = (NiRTTI *)0x03284CC8;
const NiRTTI *	NiRTTI_BSDistantObjectLargeRefExtraData = (NiRTTI *)0x03284CD8;
const NiRTTI *	NiRTTI_BSMasterParticleSystem = (NiRTTI *)0x032866A0;
const NiRTTI *	NiRTTI_BSProceduralLightningController = (NiRTTI *)0x032866C8;
const NiRTTI *	NiRTTI_BSInvMarker = (NiRTTI *)0x032866D8;
const NiRTTI *	NiRTTI_BSBoneLODExtraData = (NiRTTI *)0x032866F0;
const NiRTTI *	NiRTTI_BSReference = (NiRTTI *)0x03286710;
const NiRTTI *	NiRTTI_BSNodeReferences = (NiRTTI *)0x03286720;
const NiRTTI *	NiRTTI_BSDecalPlacementVectorExtraData = (NiRTTI *)0x03286730;
const NiRTTI *	NiRTTI_BSParentVelocityModifier = (NiRTTI *)0x03286740;
const NiRTTI *	NiRTTI_BSWArray = (NiRTTI *)0x03286750;
const NiRTTI *	NiRTTI_BSMultiBoundCapsule = (NiRTTI *)0x03286768;
const NiRTTI *	NiRTTI_BSPSysStripUpdateModifier = (NiRTTI *)0x03286778;
const NiRTTI *	NiRTTI_BSPSysSubTexModifier = (NiRTTI *)0x03286788;
const NiRTTI *	NiRTTI_BSPSysScaleModifier = (NiRTTI *)0x03286798;
const NiRTTI *	NiRTTI_BSLagBoneController = (NiRTTI *)0x032867A8;
const NiRTTI *	NiRTTI_BSNonUniformScaleExtraData = (NiRTTI *)0x032867B8;
const NiRTTI *	NiRTTI_BSNiNode = (NiRTTI *)0x032867D0;
const NiRTTI *	NiRTTI_BSInstanceTriShape = (NiRTTI *)0x032867E0;
const NiRTTI *	NiRTTI_bhkWorldObject = (NiRTTI *)0x0328CD68;
const NiRTTI *	NiRTTI_bhkWorld = (NiRTTI *)0x0328CDA8;
const NiRTTI *	NiRTTI_bhkRigidBody = (NiRTTI *)0x0328DEE8;
const NiRTTI *	NiRTTI_bhkCollisionObject = (NiRTTI *)0x0328DF00;
const NiRTTI *	NiRTTI_bhkNiCollisionObject = (NiRTTI *)0x0328DFB0;
const NiRTTI *	NiRTTI_bhkAttachmentCollisionObject = (NiRTTI *)0x0328E030;
const NiRTTI *	NiRTTI_WeaponObject = (NiRTTI *)0x0328E040;
const NiRTTI *	NiRTTI_bhkRigidBodyT = (NiRTTI *)0x0328E068;
const NiRTTI *	NiRTTI_bhkWorldM = (NiRTTI *)0x0328E078;
const NiRTTI *	NiRTTI_bhkRefObject = (NiRTTI *)0x0328E0A0;
const NiRTTI *	NiRTTI_bhkSerializable = (NiRTTI *)0x0328E0B0;
const NiRTTI *	NiRTTI_bhkShape = (NiRTTI *)0x0328E0E0;
const NiRTTI *	NiRTTI_bhkEntity = (NiRTTI *)0x0328E0F8;
const NiRTTI *	NiRTTI_bhkPhantom = (NiRTTI *)0x0328E110;
const NiRTTI *	NiRTTI_bhkAabbPhantom = (NiRTTI *)0x0328E128;
const NiRTTI *	NiRTTI_bhkSphereRepShape = (NiRTTI *)0x0328E140;
const NiRTTI *	NiRTTI_bhkConvexShape = (NiRTTI *)0x0328E158;
const NiRTTI *	NiRTTI_bhkPCollisionObject = (NiRTTI *)0x0328E168;
const NiRTTI *	NiRTTI_hkPackedNiTriStripsData = (NiRTTI *)0x0328E178;
const NiRTTI *	NiRTTI_bhkShapePhantom = (NiRTTI *)0x0328E190;
const NiRTTI *	NiRTTI_bhkSimpleShapePhantom = (NiRTTI *)0x0328E1A8;
const NiRTTI *	NiRTTI_bhkCapsuleShape = (NiRTTI *)0x0328E1C0;
const NiRTTI *	NiRTTI_bhkBoxShape = (NiRTTI *)0x0328E1D8;
const NiRTTI *	NiRTTI_bhkSphereShape = (NiRTTI *)0x0328E1F0;
const NiRTTI *	NiRTTI_bhkBvTreeShape = (NiRTTI *)0x0328E208;
const NiRTTI *	NiRTTI_bhkNiTriStripsShape = (NiRTTI *)0x0328E220;
const NiRTTI *	NiRTTI_bhkPackedNiTriStripsShape = (NiRTTI *)0x0328E248;
const NiRTTI *	NiRTTI_bhkBlendCollisionObject = (NiRTTI *)0x0328E260;
const NiRTTI *	NiRTTI_bhkAvoidBox = (NiRTTI *)0x0328E280;
const NiRTTI *	NiRTTI_bhkLimitedHingeConstraint = (NiRTTI *)0x0328E298;
const NiRTTI *	NiRTTI_bhkMalleableConstraint = (NiRTTI *)0x0328E2B0;
const NiRTTI *	NiRTTI_bhkUnaryAction = (NiRTTI *)0x0328E2C8;
const NiRTTI *	NiRTTI_bhkConstraint = (NiRTTI *)0x0328E2E0;
const NiRTTI *	NiRTTI_bhkPrismaticConstraint = (NiRTTI *)0x0328E2F8;
const NiRTTI *	NiRTTI_bhkAction = (NiRTTI *)0x0328E310;
const NiRTTI *	NiRTTI_bhkTriSampledHeightFieldBvTreeShape = (NiRTTI *)0x0328E328;
const NiRTTI *	NiRTTI_bhkCachingShapePhantom = (NiRTTI *)0x0328EF98;
const NiRTTI *	NiRTTI_bhkRagdollTemplateData = (NiRTTI *)0x0328EFC0;
const NiRTTI *	NiRTTI_bhkRagdollTemplate = (NiRTTI *)0x0328EFD0;
const NiRTTI *	NiRTTI_bhkSPCollisionObject = (NiRTTI *)0x0328EFE0;
const NiRTTI *	NiRTTI_bhkMouseSpringAction = (NiRTTI *)0x0328EFF8;
const NiRTTI *	NiRTTI_bhkHingeConstraint = (NiRTTI *)0x0328F010;
const NiRTTI *	NiRTTI_bhkCompressedMeshShape = (NiRTTI *)0x0328F088;
const NiRTTI *	NiRTTI_bhkCompressedMeshShapeData = (NiRTTI *)0x0328F098;
const NiRTTI *	NiRTTI_bhkConvexSweepShape = (NiRTTI *)0x0328F0B0;
const NiRTTI *	NiRTTI_bhkConvexTransformShape = (NiRTTI *)0x0328F0C8;
const NiRTTI *	NiRTTI_bhkConvexTranslateShape = (NiRTTI *)0x0328F0E0;
const NiRTTI *	NiRTTI_bhkConvexVerticesShape = (NiRTTI *)0x0328F0F8;
const NiRTTI *	NiRTTI_bhkCylinderShape = (NiRTTI *)0x0328F110;
const NiRTTI *	NiRTTI_bhkMultiSphereShape = (NiRTTI *)0x0328F128;
const NiRTTI *	NiRTTI_bhkPlaneShape = (NiRTTI *)0x0328F140;
const NiRTTI *	NiRTTI_bhkTriangleShape = (NiRTTI *)0x0328F158;
const NiRTTI *	NiRTTI_bhkMoppBvTreeShape = (NiRTTI *)0x0328F170;
const NiRTTI *	NiRTTI_bhkTransformShape = (NiRTTI *)0x0328F188;
const NiRTTI *	NiRTTI_bhkListShape = (NiRTTI *)0x0328F1A0;
const NiRTTI *	NiRTTI_bhkBallAndSocketConstraint = (NiRTTI *)0x0328F1B8;
const NiRTTI *	NiRTTI_bhkBallSocketConstraintChain = (NiRTTI *)0x0328F1D0;
const NiRTTI *	NiRTTI_bhkGroupConstraint = (NiRTTI *)0x0328F1E8;
const NiRTTI *	NiRTTI_bhkHingeLimitsConstraint = (NiRTTI *)0x0328F200;
const NiRTTI *	NiRTTI_bhkFixedConstraint = (NiRTTI *)0x0328F218;
const NiRTTI *	NiRTTI_bhkRagdollConstraint = (NiRTTI *)0x0328F230;
const NiRTTI *	NiRTTI_bhkRagdollLimitsConstraint = (NiRTTI *)0x0328F248;
const NiRTTI *	NiRTTI_bhkStiffSpringConstraint = (NiRTTI *)0x0328F260;
const NiRTTI *	NiRTTI_bhkWheelConstraint = (NiRTTI *)0x0328F278;
const NiRTTI *	NiRTTI_bhkBreakableConstraint = (NiRTTI *)0x0328F290;
const NiRTTI *	NiRTTI_bhkAngularDashpotAction = (NiRTTI *)0x0328F2A8;
const NiRTTI *	NiRTTI_bhkDashpotAction = (NiRTTI *)0x0328F2C0;
const NiRTTI *	NiRTTI_bhkLiquidAction = (NiRTTI *)0x0328F2D8;
const NiRTTI *	NiRTTI_bhkMotorAction = (NiRTTI *)0x0328F2F8;
const NiRTTI *	NiRTTI_bhkOrientHingedBodyAction = (NiRTTI *)0x0328F310;
const NiRTTI *	NiRTTI_bhkSpringAction = (NiRTTI *)0x0328F328;
const NiRTTI *	NiRTTI_bhkBlendController = (NiRTTI *)0x0328F338;
const NiRTTI *	NiRTTI_bhkExtraData = (NiRTTI *)0x0328F348;
const NiRTTI *	NiRTTI_bhkPoseArray = (NiRTTI *)0x0328F358;
const NiRTTI *	NiRTTI_bhkGenericConstraint = (NiRTTI *)0x0328F378;
const NiRTTI *	NiRTTI_bhkCharControllerShape = (NiRTTI *)0x0328F388;
const NiRTTI *	NiRTTI_bhkCollisionBox = (NiRTTI *)0x0328F3A0;
const NiRTTI *	NiRTTI_bhkShapeCollection = (NiRTTI *)0x0328F3B8;
const NiRTTI *	NiRTTI_bhkPositionConstraintMotor = (NiRTTI *)0x0328F420;
const NiRTTI *	NiRTTI_bhkVelocityConstraintMotor = (NiRTTI *)0x0328F430;
const NiRTTI *	NiRTTI_bhkSpringDamperConstraintMotor = (NiRTTI *)0x0328F440;
const NiRTTI *	NiRTTI_bhkCharacterProxy = (NiRTTI *)0x032901F8;
const NiRTTI *	NiRTTI_bhkCharacterRigidBody = (NiRTTI *)0x03290210;
const NiRTTI *	NiRTTI_bhkHeightFieldShape = (NiRTTI *)0x03291518;
const NiRTTI *	NiRTTI_bhkConstraintChain = (NiRTTI *)0x03291530;
const NiRTTI *	NiRTTI_bhkBinaryAction = (NiRTTI *)0x03291548;
const NiRTTI *	NiRTTI_bhkPointToPathConstraint = (NiRTTI *)0x03291580;
const NiRTTI *	NiRTTI_DebugTextExtraData = (NiRTTI *)0x03292D90;
const NiRTTI *	NiRTTI_BSFadeNode = (NiRTTI *)0x0332A288;
const NiRTTI *	NiRTTI_BSShaderProperty = (NiRTTI *)0x0332A2B8;
const NiRTTI *	NiRTTI_BSLeafAnimNode = (NiRTTI *)0x0332A2C8;
const NiRTTI *	NiRTTI_BSTreeNode = (NiRTTI *)0x0332A2D8;
const NiRTTI *	NiRTTI_ShadowSceneNode = (NiRTTI *)0x0332A700;
const NiRTTI *	NiRTTI_BSLightingShaderProperty = (NiRTTI *)0x0332AFD0;
const NiRTTI *	NiRTTI_BSGrassShaderProperty = (NiRTTI *)0x0332B008;
const NiRTTI *	NiRTTI_BSShaderAccumulator = (NiRTTI *)0x0332B220;
const NiRTTI *	NiRTTI_BSEffectShaderProperty = (NiRTTI *)0x0332B3C0;
const NiRTTI *	NiRTTI_BSWaterShaderProperty = (NiRTTI *)0x0338C1E8;
const NiRTTI *	NiRTTI_BSBloodSplatterShaderProperty = (NiRTTI *)0x0338C1F8;
const NiRTTI *	NiRTTI_BSParticleShaderProperty = (NiRTTI *)0x0338C5E8;
const NiRTTI *	NiRTTI_BSTextureSet = (NiRTTI *)0x0338C938;
const NiRTTI *	NiRTTI_BSShaderTextureSet = (NiRTTI *)0x0338C948;
const NiRTTI *	NiRTTI_BSSkyShaderProperty = (NiRTTI *)0x0338CC48;
const NiRTTI *	NiRTTI_BSFadeNodeCuller = (NiRTTI *)0x033DCCD0;
const NiRTTI *	NiRTTI_BSDistantTreeShaderProperty = (NiRTTI *)0x033DCD00;
const NiRTTI *	NiRTTI_BSCubeMapCamera = (NiRTTI *)0x033DCEE0;
const NiRTTI *	NiRTTI_BSFogProperty = (NiRTTI *)0x033DCF98;
const NiRTTI *	NiRTTI_BSClearZNode = (NiRTTI *)0x035EF058;
const NiRTTI *	NiRTTI_NiCollisionObject = (NiRTTI *)0x035EF178;
const NiRTTI *	NiRTTI_BSOrderedNode = (NiRTTI *)0x035EF188;
const NiRTTI *	NiRTTI_BSLines = (NiRTTI *)0x035EF198;
const NiRTTI *	NiRTTI_BSDynamicLines = (NiRTTI *)0x035EF1A8;
const NiRTTI *	NiRTTI_BSMultiIndexTriShape = (NiRTTI *)0x035EF1C8;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyFloatController = (NiRTTI *)0x035EF270;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyUShortController = (NiRTTI *)0x035EF288;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyColorController = (NiRTTI *)0x035EF2A0;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyFloatController = (NiRTTI *)0x035EF2D8;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyColorController = (NiRTTI *)0x035EF2F0;
const NiRTTI *	NiRTTI_BSNiAlphaPropertyTestRefController = (NiRTTI *)0x035EF300;
const NiRTTI *	NiRTTI_BSPSysSimpleColorModifier = (NiRTTI *)0x035EF310;
const NiRTTI *	NiRTTI_BSPSysLODModifier = (NiRTTI *)0x035EF320;
const NiRTTI *	NiRTTI_BSParabolicCullingProcess = (NiRTTI *)0x035EF7A8;
const NiRTTI *	NiRTTI_BSMeshLODTriShape = (NiRTTI *)0x035EF7B8;
const NiRTTI *	NiRTTI_BSLODMultiIndexTriShape = (NiRTTI *)0x035EF7C8;
const NiRTTI *	NiRTTI_BSSubIndexLandTriShape = (NiRTTI *)0x035EF7E0;
